<?php

	mb_internal_encoding('UTF-8');

	if ( $argc < 3 )
		die('ERROR: Not enough parameters.' . "\n");

	$language					= $argv[1];
	$config_file				= $argv[2];
	$config						= parse_ini_file($config_file);
	$iate_form_lemmas			= json_decode(file_get_contents($config['IATE_FOLDER'] . '/iate_forms_lemmas_' . $language . '.json'), true);
	$iate_lemmas				= array();

	foreach ( $iate_form_lemmas as $iate_id => $data ) {

		$lemmas = array_filter(array_keys($data));
		$iate_lemmas[$iate_id] = $lemmas;
	}

	uasort($iate_lemmas, function($a, $b) {

		if ( count($a) == count($b) )
			return 0;

		return ( count($a) < count($b) ) ? 1 : -1;
	});

	foreach ( $iate_lemmas as $iate_id => $lemmas )
		sort($iate_lemmas[$iate_id]);

	file_put_contents($config['IATE_FOLDER'] . '/iate_lemmas_' . $language . '.json', json_encode($iate_lemmas, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES));

?>