<?php

	mb_internal_encoding('UTF-8');

	if ( $argc < 3 )
		die('ERROR: Not enough parameters.' . "\n");

	$language				= $argv[1];
	$config_file			= $argv[2];
	$config					= parse_ini_file($config_file);
	$iate_simple			= json_decode(file_get_contents($config['IATE_FOLDER'] . '/iate_simple_' . $language . '.json'), true);
	$iate_search			= array();

	foreach ( $iate_simple as $iate_id => $synonyms ) {
		foreach ( $synonyms as $synonym ) {

			$lemmas = explode(' ', $synonym);
			$lemmas = array_map('mb_strtolower', $lemmas);

			$first_lemma = $lemmas[0];
			if ( !array_key_exists($first_lemma, $iate_search) )
				$iate_search[$first_lemma] = array();

			$iate_search[$first_lemma][] = array(
				'code'			=> $iate_id,
				'length'		=> count($lemmas),
				'name'			=> implode(' ', $lemmas)
			);
		}
	}

	uasort($iate_search, function($a, $b) {

		if ( count($a) == count($b) )
			return 0;

			return ( count($a) < count($b) ) ? 1 : -1;
	});

	foreach ( $iate_search as $first_lemma => $lemma_data )
		uasort($iate_search[$first_lemma], function($a, $b) {

			if ( $a['length'] == $b['length'] )
				return 0;

			 return ( $a['length'] < $b['length'] ) ? 1 : -1;
		});

	file_put_contents($config['IATE_FOLDER'] . '/iate_form_search_' . $language . '.json', json_encode($iate_search, JSON_PRETTY_PRINT | JSON_UNESCAPED_SLASHES | JSON_UNESCAPED_UNICODE));

?>