<?php

	mb_internal_encoding('UTF-8');

	if ( $argc < 2 )
		die('ERROR: Not enough parameters.' . "\n");

	$config_file			= $argv[1];
	$config					= parse_ini_file($config_file);
	$languages				= explode(',', $config['LANGUAGES']);
	$languages				= array_map('trim', $languages);

	$codes = array();

	$iate_lemmas_corpus = array();
	foreach ( $languages as $language )
		$iate_lemmas_corpus[$language] = json_decode(file_get_contents($config['IATE_FOLDER'] . '/iate_lemmas_corpus_' . $language . '.json'), true);

	foreach ( $languages as $language ) {
		foreach ( $iate_lemmas_corpus[$language] as $document_name => $document_data ) {
			foreach ( $document_data as $code => $count ) {

				if ( !array_key_exists($code, $codes) )
					$codes[$code] = array_fill_keys($languages, 0);

				$codes[$code][$language]++;
			}
		}
	}

	$codes_intersected = array_keys(array_filter($codes, function($counts) { return !in_array(0, $counts); }));
	sort($codes_intersected);

	file_put_contents($config['IATE_FOLDER'] . '/iate_intersected_ids.json', json_encode($codes_intersected, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES));

?>