<?php

	mb_internal_encoding('UTF-8');

	if ( $argc < 2 )
		die('ERROR: Not enough parameters.' . "\n");

	$config_file			= $argv[1];
	if ( !file_exists($config_file) )
		die('ERROR: Cannot open file: ' . $config_file . "\n");

	$config					= parse_ini_file($config_file);
	$languages				= explode(',', $config['LANGUAGES']);
	$languages				= array_map('trim', $languages);

	$codes = array('eu' => array(), 'ia' => array(), 'te' => array(), 'le' => array());

	$multi_corpus = array();
	foreach ( $languages as $language )
		$multi_corpus[$language] = json_decode(file_get_contents($config['MULTI_CORPUS_FOLDER'] . '/multi_corpus_' . $language . '.json'), true);

	foreach ( $languages as $language ) {
		foreach ( $multi_corpus[$language] as $document_name => $document_data ) {
			foreach ( $document_data as $code => $count ) {

				$prefix = mb_strtolower(mb_substr($code, 0, 2));

				if ( !array_key_exists($code, $codes[$prefix]) )
					$codes[$prefix][$code] = array_fill_keys($languages, 0);

				$codes[$prefix][$code][$language]++;
			}
		}
	}

	foreach ( array('eu', 'ia', 'te', 'le') as $prefix )
		$codes_intersected[$prefix] = array_filter($codes[$prefix], function($counts) { return !in_array(0, $counts); });

	foreach ( $languages as $language )
		foreach ( $multi_corpus[$language] as $document_name => $document_data )
			foreach ( $document_data as $code => $count ) {

				$prefix = mb_strtolower(mb_substr($code, 0, 2));

				if ( !array_key_exists($code, $codes_intersected[$prefix]) )
					unset($multi_corpus[$language][$document_name][$code]);
			}

	foreach ( $languages as $language )
		$multi_corpus[$language] = array_filter($multi_corpus[$language], function($document_data) { return count($document_data) != 0; });

	foreach ( $languages as $language )
		file_put_contents($config['MULTI_CORPUS_FOLDER'] . '/multi_corpus_intersected_' . $language . '.json', json_encode($multi_corpus[$language], JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES));

?>