<?php

	mb_internal_encoding('UTF-8');

	if ( $argc < 3 )
		die('ERROR: Not enough parameters.' . "\n");

	$language				= $argv[1];
	$config_file			= $argv[2];
	if ( !file_exists($config_file) )
		die('ERROR: Cannot open file: ' . $config_file . "\n");

	$config					= parse_ini_file($config_file);
	$language_positions		= get_language_positions($config);
	$all_terms				= load_terms($config['TERMS_FILE'], $language);
	$terms					= array();

	foreach ( $all_terms as $term => $ids )
		foreach ( $ids as $id )
			$terms['TERM_' . $id] = array($term);

	file_put_contents($config['TERM_FOLDER'] . '/terms_' . $language . '.json', json_encode($terms, JSON_PRETTY_PRINT | JSON_UNESCAPED_SLASHES | JSON_UNESCAPED_UNICODE));

	function load_terms($terms_file, $language) {

		global $language_positions;

		$all_terms = array();

		$lines = file($terms_file);
		foreach ( $lines as $i => $line ) {

			$line = trim($line);
			$entry = explode("\t", $line);
			if ( count($entry) != 7 )
				continue;

			$term = $entry[$language_positions[$language]];
			$term = mb_strtolower($term);

			if ( !empty($term) ) {

				if ( !array_key_exists($term, $all_terms) )
					$all_terms[$term] = array();

				$all_terms[$term][] = $i;
			}
		}

		return $all_terms;
	}

	function get_language_positions($config) {

		$languages = explode(',', $config['LANGUAGES']);
		$languages = array_map('trim', $languages);
		$language_positions = array_flip($languages);

		return $language_positions;
	}

?>