<?php

	mb_internal_encoding('UTF-8');

	if ( $argc < 3 )
		die('ERROR: Not enough parameters.' . "\n");

	$language					= $argv[1];
	$config_file				= $argv[2];
	$config						= parse_ini_file($config_file);
	$term_form_lemmas			= json_decode(file_get_contents($config['TERM_FOLDER'] . '/term_form_lemmas_' . $language . '.json'), true);
	$term_lemmas				= array();

	foreach ( $term_form_lemmas as $term_id => $data ) {

		$lemmas = array_filter(array_keys($data));
		$term_lemmas[$term_id] = $lemmas;
	}

	uasort($term_lemmas, function($a, $b) {

		if ( count($a) == count($b) )
			return 0;

		return ( count($a) < count($b) ) ? 1 : -1;
	});

	foreach ( $term_lemmas as $term_id => $lemmas )
		sort($term_lemmas[$term_id]);

	file_put_contents($config['TERM_FOLDER'] . '/term_lemmas_' . $language . '.json', json_encode($term_lemmas, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES));

?>