<?php

	mb_internal_encoding('UTF-8');

	if ( $argc < 3 )
		die('ERROR: Not enough parameters.' . "\n");

	$language				= $argv[1];
	$config_file			= $argv[2];
	$config					= parse_ini_file($config_file);
	$corpora_folder			= get_corpora_folder($config);
	$corpus_folder			= $corpora_folder . '/' . $language . '/conllup';
	$term_search			= json_decode(file_get_contents($config['TERM_FOLDER'] . '/term_form_search_' . $language . '.json'), true);
	$term_lemmas			= array();
	$document_names			= array_diff(scandir($corpus_folder), array('.', '..'));
	$total					= count($document_names);

	fwrite(STDERR, "Extracting lemmas from forms...\n");
	foreach ( $document_names as $i => $document_name ) {

		list($sentences_lemmas, $sentences_forms) = get_sentences($corpus_folder . '/' . $document_name);

		foreach ( $sentences_lemmas as $j => $sentence_lemmas )
			process_sentence($sentence_lemmas, $sentences_forms[$j]);

		if ( $i % 100 == 0 )
			fwrite(STDERR, round($i * 100 / $total, 2) . "%\r");
	}
	fwrite(STDERR, "100%    \n");
	fwrite(STDERR, "DONE\n");

	uasort($term_lemmas, function($a, $b) {

		if ( count($a) == count($b) )
			return 0;

		return ( count($a) < count($b) ) ? 1 : -1;
	});

	foreach ( $term_lemmas as $term_id => $lemmas )
		arsort($term_lemmas[$term_id]);

	file_put_contents($config['TERM_FOLDER'] . '/term_form_lemmas_' . $language . '.json', json_encode($term_lemmas, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES));

	function process_sentence($sentence_lemmas, $sentence_forms) {

		global $term_search, $term_lemmas;

		$matches = array();

		$length = count($sentence_forms);
		foreach ( $sentence_forms as $i => $form ) {

			if ( !array_key_exists($form, $term_search) )
				continue;

			foreach ( $term_search[$form] as $candidate ) {

				if ( $i + $candidate['length'] > $length )
					continue;

				$code = $candidate['code'];
				$phrase = implode(' ', array_slice($sentence_forms, $i, $candidate['length']));
				if ( $candidate['name'] != $phrase )
					continue;

				$candidate_lemmas = array_slice($sentence_lemmas, $i, $candidate['length']);
				if ( !array_key_exists($code, $term_lemmas) )
					$term_lemmas[$code] = array();

				$lemmas_key = implode(' ', $candidate_lemmas);
				if ( !array_key_exists($lemmas_key, $term_lemmas[$code]) )
					$term_lemmas[$code][$lemmas_key] = 0;

				$term_lemmas[$code][$lemmas_key]++;
			}
		}
	}

	function get_sentences($document_path) {

		$sentences_lemmas = array();
		$sentences_forms = array();
		$sentence_lemmas = array();
		$sentence_forms = array();

		$lines = file($document_path);
		foreach ( $lines as $i => $line ) {

			$line = trim($line);
			if ( empty($line) )
				continue;

			$entry = explode("\t", $line);
			if ( count($entry) != 14 ) {

				if ( count($sentence_forms) != 0 ) {

					$sentences_lemmas[] = $sentence_lemmas;
					$sentences_forms[] = $sentence_forms;
					$sentence_lemmas = array();
					$sentence_forms = array();
				}

				continue;
			}

			$lemma = mb_strtolower($entry[2]);
			$form = mb_strtolower($entry[1]);

			$sentence_lemmas[] = $lemma;
			$sentence_forms[] = $form;
		}

		if ( count($sentence_forms) != 0 ) {

			$sentences_lemmas[] = $sentence_lemmas;
			$sentences_forms[] = $sentence_forms;
		}

		return array($sentences_lemmas, $sentences_forms);
	}

	function get_corpora_folder($config) {

		return rtrim($config['CORPORA_FOLDER'], '/');
	}

?>