<?php

	mb_internal_encoding('UTF-8');

	if ( $argc < 3 )
		die('ERROR: Not enough parameters.' . "\n");

	$language				= $argv[1];
	$config_file			= $argv[2];
	$config					= parse_ini_file($config_file);
	$term_lemmas			= json_decode(file_get_contents($config['TERM_FOLDER'] . '/term_lemmas_' . $language . '.json'), true);
	$term_search			= array();
	$remove					= array('hu' => array('a', 'az'), 'ro' => array('o', 'un'));

	foreach ( $term_lemmas as $term_id => $synonyms ) {
		foreach ( $synonyms as $synonym ) {

			$lemmas = explode(' ', $synonym);
			$lemmas = array_map('mb_strtolower', $lemmas);

			if ( array_key_exists($language, $remove) ) {

				if ( in_array($lemmas[0], $remove[$language]) )
					$lemmas = array_slice($lemmas, 1);

				if ( count($lemmas) == 0 )
					continue;
			}

			$first_lemma = $lemmas[0];
			if ( !array_key_exists($first_lemma, $term_search) )
				$term_search[$first_lemma] = array();

			$term_search[$first_lemma][] = array(
				'code'			=> $term_id,
				'length'		=> count($lemmas),
				'name'			=> implode(' ', $lemmas)
			);
		}
	}

	uasort($term_search, function($a, $b) {

		if ( count($a) == count($b) )
			return 0;

			return ( count($a) < count($b) ) ? 1 : -1;
	});

	foreach ( $term_search as $first_lemma => $lemma_data )
		usort($term_search[$first_lemma], function($a, $b) {

			if ( $a['length'] == $b['length'] )
				return 0;

			 return ( $a['length'] < $b['length'] ) ? 1 : -1;
		});

	file_put_contents($config['TERM_FOLDER'] . '/term_lemma_search_' . $language . '.json', json_encode($term_search, JSON_PRETTY_PRINT | JSON_UNESCAPED_SLASHES | JSON_UNESCAPED_UNICODE));

?>