<?php

	mb_internal_encoding('UTF-8');

	if ( $argc < 2 )
		die('ERROR: Not enough parameters.' . "\n");

	$config_file			= $argv[1];
	if ( !file_exists($config_file) )
		die('ERROR: Cannot open file: ' . $config_file . "\n");

	$config					= parse_ini_file($config_file);
	$languages				= explode(',', $config['LANGUAGES']);
	$languages				= array_map('trim', $languages);
	$use_intersect			= intval($config['USE_INTERSECT']);

	chdir('Eurovoc');
	foreach ( $languages as $language ) {

		fwrite(STDERR, "Processing $language ...\n");
		system('php eurovoc_extended_extract.php ' . $language . " '../" . $config_file . "'");
		system('php eurovoc_forms_search.php ' . $language . " '../" . $config_file . "'");
		system('php eurovoc_forms_lemmas.php ' . $language . " '../" . $config_file . "'");
		system('php eurovoc_convert_lemmas.php ' . $language . " '../" . $config_file . "'");
		system('php eurovoc_lemmas_search.php ' . $language . " '../" . $config_file . "'");
		if ( $use_intersect == 1 )
			system('php eurovoc_lemmas_corpus.php ' . $language . " '../" . $config_file . "'");
		fwrite(STDERR, "DONE\n");
	}

	if ( $use_intersect == 1 ) {

		fwrite(STDERR, "Intersecting...\n");
		system('php eurovoc_intersected_ids.php' . " '../" . $config_file . "'");
		fwrite(STDERR, "DONE\n");
	}

	chdir('..');

?>