<?php

	mb_internal_encoding('UTF-8');

	if ( $argc < 2 )
		die('ERROR: Not enough parameters.' . "\n");

	$config_file			= $argv[1];
	if ( !file_exists($config_file) )
		die('ERROR: Cannot open file: ' . $config_file . "\n");

	$config					= parse_ini_file($config_file);
	$languages				= explode(',', $config['LANGUAGES']);
	$languages				= array_map('trim', $languages);

	chdir('Lemmas');
	foreach ( $languages as $language ) {

		fwrite(STDERR, "Processing $language ...\n");
		system('php get_lemmas.php ' . $language . " '../" . $config_file . "'");
		system('php lemma_search.php ' . $language . " '../" . $config_file . "'");
		fwrite(STDERR, "DONE\n");
	}
	chdir('..');

?>