<?php

	mb_internal_encoding('UTF-8');

	if ( $argc < 2 )
		die('ERROR: Not enough parameters.' . "\n");

	$config_file			= $argv[1];
	if ( !file_exists($config_file) )
		die('ERROR: Cannot open file: ' . $config_file . "\n");

	$config					= parse_ini_file($config_file);
	$languages				= explode(',', $config['LANGUAGES']);
	$languages				= array_map('trim', $languages);

	chdir('Corpora_Representation');
	foreach ( $languages as $language ) {

		fwrite(STDERR, "Processing $language ...\n");
		if ( $config['DATA_EUROVOC_2'] == 0 )
			system('php generate_representation.php ' . $language . ' ' . "'../" . $config_file . "'");
		else
			system('php generate_representation_eurovoc_2.php ' . $language . ' ' . "'../" . $config_file . "'");

		if ( $config['DATA_EUROVOC_2'] == 0 )
			system('php generate_annotated_representation.php ' . $language . ' ' . "'../" . $config_file . "'");
		else
			system('php generate_annotated_representation_eurovoc_2.php ' . $language . ' ' . "'../" . $config_file . "'");

		fwrite(STDERR, "DONE\n");
	}
	chdir('..');

?>