<?php

	mb_internal_encoding('UTF-8');

	if ( $argc < 3 )
		die('ERROR: Not enough parameters.' . "\n");

	$language					= $argv[1];
	$config_file				= $argv[2];
	$config						= parse_ini_file($config_file);
	$eurovoc_form_lemmas		= json_decode(file_get_contents($config['EUROVOC_FOLDER'] . '/eurovoc_forms_lemmas_' . $language . '.json'), true);
	$eurovoc_lemmas				= array();

	foreach ( $eurovoc_form_lemmas as $eurovoc_id => $data ) {

		$lemmas = array_filter(array_keys($data));
		$eurovoc_lemmas[$eurovoc_id] = $lemmas;
	}

	uasort($eurovoc_lemmas, function($a, $b) {

		if ( count($a) == count($b) )
			return 0;

		return ( count($a) < count($b) ) ? 1 : -1;
	});

	foreach ( $eurovoc_lemmas as $eurovoc_id => $lemmas )
		sort($eurovoc_lemmas[$eurovoc_id]);

	file_put_contents($config['EUROVOC_FOLDER'] . '/eurovoc_lemmas_' . $language . '.json', json_encode($eurovoc_lemmas, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES));

?>