<?php

	mb_internal_encoding('UTF-8');

	if ( $argc < 3 )
		die('ERROR: Not enough parameters.' . "\n");

	$language				= $argv[1];
	$config_file			= $argv[2];
	$config					= parse_ini_file($config_file);
	$eurovoc_extended		= json_decode(file_get_contents($config['EUROVOC_FOLDER'] . '/eurovoc_extended_' . $language . '.json'), true);
	$eurovoc_search			= array();

	foreach ( $eurovoc_extended as $descriptor_id => $synonyms ) {
		foreach ( $synonyms as $synonym ) {

			$lemmas = explode(' ', $synonym);
			$lemmas = array_map('mb_strtolower', $lemmas);

			$first_lemma = $lemmas[0];
			if ( !array_key_exists($first_lemma, $eurovoc_search) )
				$eurovoc_search[$first_lemma] = array();

			$eurovoc_search[$first_lemma][] = array(
				'code'			=> $descriptor_id,
				'length'		=> count($lemmas),
				'name'			=> implode(' ', $lemmas)
			);
		}
	}

	uasort($eurovoc_search, function($a, $b) {

		if ( count($a) == count($b) )
			return 0;

			return ( count($a) < count($b) ) ? 1 : -1;
	});

	foreach ( $eurovoc_search as $first_lemma => $lemma_data )
		uasort($eurovoc_search[$first_lemma], function($a, $b) {

			if ( $a['length'] == $b['length'] )
				return 0;

			 return ( $a['length'] < $b['length'] ) ? 1 : -1;
		});

	file_put_contents($config['EUROVOC_FOLDER'] . '/eurovoc_form_search_' . $language . '.json', json_encode($eurovoc_search, JSON_PRETTY_PRINT | JSON_UNESCAPED_SLASHES | JSON_UNESCAPED_UNICODE));

?>