<?php

	mb_internal_encoding('UTF-8');

	if ( $argc < 3 )
		die('ERROR: Not enough parameters.' . "\n");

	$language				= $argv[1];
	$config_file			= $argv[2];
	if ( !file_exists($config_file) )
		die('ERROR: Cannot open file: ' . $config_file . "\n");

	$config					= parse_ini_file($config_file);
	$language_positions		= get_language_positions($config);
	$all_lemmas				= load_lemmas($config['LEMMAS_FILE'], $language);
	$lemmas					= array();

	foreach ( $all_lemmas as $lemma => $ids )
		foreach ( $ids as $id )
			$lemmas['LEMMA_' . $id] = array($lemma);

	file_put_contents($config['LEMMA_FOLDER'] . '/lemmas_' . $language . '.json', json_encode($lemmas, JSON_PRETTY_PRINT | JSON_UNESCAPED_SLASHES | JSON_UNESCAPED_UNICODE));

	function load_lemmas($lemmas_file, $language) {

		global $language_positions;

		$all_lemmas = array();

		$lines = file($lemmas_file);
		foreach ( $lines as $i => $line ) {

			$line = trim($line);
			$entry = explode("\t", $line);
			if ( count($entry) != 7 )
				continue;

			$lemma = $entry[$language_positions[$language]];
			$lemma = mb_strtolower($lemma);

			if ( !empty($lemma) ) {

				if ( !array_key_exists($lemma, $all_lemmas) )
					$all_lemmas[$lemma] = array();

				$all_lemmas[$lemma][] = $i;
			}
		}

		return $all_lemmas;
	}

	function get_language_positions($config) {

		$languages = explode(',', $config['LANGUAGES']);
		$languages = array_map('trim', $languages);
		$language_positions = array_flip($languages);

		return $language_positions;
	}

?>