<?php

	mb_internal_encoding('UTF-8');

	if ( $argc < 3 )
		die('ERROR: Not enough parameters.' . "\n");

	$language				= $argv[1];
	$config_file			= $argv[2];
	if ( !file_exists($config_file) )
		die('ERROR: Cannot open file: ' . $config_file . "\n");

	$config				= parse_ini_file($config_file);
	$lemmas				= json_decode(file_get_contents($config['LEMMA_FOLDER'] . '/lemmas_' . $language . '.json'), true);
	$lemma_search		= array();

	foreach ( $lemmas as $lemma_id => $synonyms ) {
		foreach ( $synonyms as $synonym ) {

			$synonym_lemmas = explode(' ', $synonym);
			$synonym_lemmas = array_map('mb_strtolower', $synonym_lemmas);

			$first_lemma = $synonym_lemmas[0];
			if ( !array_key_exists($first_lemma, $lemma_search) )
				$lemma_search[$first_lemma] = array();

			$lemma_search[$first_lemma][] = array(
				'code'			=> $lemma_id,
				'length'		=> count($synonym_lemmas),
				'name'			=> implode(' ', $synonym_lemmas)
			);
		}
	}

	uasort($lemma_search, function($a, $b) {

		if ( count($a) == count($b) )
			return 0;

			return ( count($a) < count($b) ) ? 1 : -1;
	});

	foreach ( $lemma_search as $first_lemma => $lemma_data )
		usort($lemma_search[$first_lemma], function($a, $b) {

			if ( $a['length'] == $b['length'] )
				return 0;

			 return ( $a['length'] < $b['length'] ) ? 1 : -1;
		});

	file_put_contents($config['LEMMA_FOLDER'] . '/lemma_search_' . $language . '.json', json_encode($lemma_search, JSON_PRETTY_PRINT | JSON_UNESCAPED_SLASHES | JSON_UNESCAPED_UNICODE));

?>