<?php

	mb_internal_encoding('UTF-8');

	if ( $argc < 3 )
		die('ERROR: Not enough parameters.' . "\n");

	$language				= $argv[1];
	$config_file			= $argv[2];
	$config					= parse_ini_file($config_file);
	$term_forms				= json_decode(file_get_contents($config['TERM_FOLDER'] . '/term_forms_' . $language . '.json'), true);
	$term_search			= array();
	$remove					= array('hu' => array('a', 'az'), 'ro' => array('o', 'un'));

	foreach ( $term_forms as $term_id => $synonyms ) {
		foreach ( $synonyms as $synonym ) {

			$forms = explode(' ', $synonym);
			$forms = array_map('mb_strtolower', $forms);

			if ( array_key_exists($language, $remove) ) {

				if ( in_array($forms[0], $remove[$language]) )
					$forms = array_slice($forms, 1);

				if ( count($forms) == 0 )
					continue;
			}

			$first_form = $forms[0];
			if ( !array_key_exists($first_form, $term_search) )
				$term_search[$first_form] = array();

			$term_search[$first_form][] = array(
				'code'			=> $term_id,
				'length'		=> count($forms),
				'name'			=> implode(' ', $forms)
			);
		}
	}

	uasort($term_search, function($a, $b) {

		if ( count($a) == count($b) )
			return 0;

			return ( count($a) < count($b) ) ? 1 : -1;
	});

	foreach ( $term_search as $first_form => $form_data )
		uasort($term_search[$first_form], function($a, $b) {

			if ( $a['length'] == $b['length'] )
				return 0;

			 return ( $a['length'] < $b['length'] ) ? 1 : -1;
		});

	file_put_contents($config['TERM_FOLDER'] . '/term_form_search_' . $language . '.json', json_encode($term_search, JSON_PRETTY_PRINT | JSON_UNESCAPED_SLASHES | JSON_UNESCAPED_UNICODE));

?>