<?php

	mb_internal_encoding('UTF-8');

	if ( $argc < 3 )
		die('ERROR: Not enough parameters.' . "\n");

	$language				= $argv[1];
	$config_file			= $argv[2];
	$config					= parse_ini_file($config_file);
	$language_positions		= get_language_positions($config);
	$terms					= load_terms($config['TERMS_FILE'], $language);
	$term_forms				= array();

	foreach ( $terms as $term => $id )
		$term_forms['TERM_' . $id] = array($term);

	file_put_contents($config['TERM_FOLDER'] . '/term_forms_' . $language . '.json', json_encode($term_forms, JSON_PRETTY_PRINT | JSON_UNESCAPED_SLASHES | JSON_UNESCAPED_UNICODE));

	function load_terms($terms_file, $language) {

		global $language_positions;

		$terms = array();

		$lines = file($terms_file);
		foreach ( $lines as $i => $line ) {

			$line = trim($line);
			$entry = explode("\t", $line);
			if ( count($entry) != 7 )
				continue;

			$term = $entry[$language_positions[$language]];
			if ( !empty($term) )
				$terms[$term] = $i;
		}

		return $terms;
	}

	function get_language_positions($config) {

		$languages = explode(',', $config['LANGUAGES']);
		$languages = array_map('trim', $languages);
		$language_positions = array_flip($languages);

		return $language_positions;
	}

?>