<?php

	mb_internal_encoding('UTF-8');

	if ( $argc < 3 )
		die('ERROR: Not enough parameters.' . "\n");

	$language				= $argv[1];
	$config_file			= $argv[2];
	if ( !file_exists($config_file) )
		die('ERROR: Cannot open file: ' . $config_file . "\n");

	$config				= parse_ini_file($config_file);
	$terms				= json_decode(file_get_contents($config['TERM_FOLDER'] . '/terms_' . $language . '.json'), true);
	$term_search		= array();

	foreach ( $terms as $term_id => $synonyms ) {
		foreach ( $synonyms as $synonym ) {

			$synonym_lemmas = explode(' ', $synonym);
			$synonym_lemmas = array_map('mb_strtolower', $synonym_lemmas);

			$first_lemma = $synonym_lemmas[0];
			if ( !array_key_exists($first_lemma, $term_search) )
				$term_search[$first_lemma] = array();

			$term_search[$first_lemma][] = array(
				'code'			=> $term_id,
				'length'		=> count($synonym_lemmas),
				'name'			=> implode(' ', $synonym_lemmas)
			);
		}
	}

	uasort($term_search, function($a, $b) {

		if ( count($a) == count($b) )
			return 0;

			return ( count($a) < count($b) ) ? 1 : -1;
	});

	foreach ( $term_search as $first_lemma => $term_data )
		usort($term_search[$first_lemma], function($a, $b) {

			if ( $a['length'] == $b['length'] )
				return 0;

			 return ( $a['length'] < $b['length'] ) ? 1 : -1;
		});

	file_put_contents($config['TERM_FOLDER'] . '/term_search_' . $language . '.json', json_encode($term_search, JSON_PRETTY_PRINT | JSON_UNESCAPED_SLASHES | JSON_UNESCAPED_UNICODE));

?>