class Embeddings:

	def __init__(self):

		self.check_isalpha = True
		self.check_entries_count = True
		self.entries_count = 101

		self.vectors = []
		self.labels = []
		self.label_names = dict()

	def load(self, embeddings_file):

		lines = open(embeddings_file, encoding='utf-8').readlines()
		for line in lines:

			entries = line.rstrip("\n ").split(' ')
			if ( self.check_entries_count and len(entries) != self.entries_count ):
				continue

			label = entries[0]
			if ( self.check_isalpha and not label.isalpha() ):
				continue

			label = entries[0]

			self.vectors.append([float(i) for i in entries[1:]])
			self.labels.append(label)
			self.label_names[label] = len(self.labels) - 1

	def exists(self, label):
		return label in self.label_names

	def get_vector(self, label):
		index = self.label_names[label]
		return self.vectors[index]

	def get_vectors(self):
		return self.vectors

	def get_labels(self):
		return self.labels

	def count(self):
		return len(self.vectors)