import os, re

class Embeddings:

	def __init__(self, embeddings_file):
		self.embeddings_file = embeddings_file
		self.embeddings = dict()

	def load(self):

		lines = open(self.embeddings_file, encoding='utf-8').readlines()
		for line in lines:

			entries = line.rstrip("\n ").split(' ')
			if ( len(entries) != 101 ):
				continue

			lemma = entries[0]
			if ( not lemma.isalpha() ):
				continue

			self.embeddings[lemma] = [float(i) for i in entries[1:]]

	def exists(self, element):
		return element in self.embeddings

	def get_vector(self, lemma):
		return self.embeddings[lemma]

	def get_embeddings(self):
		return self.embeddings