<?php

	mb_internal_encoding('UTF-8');

	if ( $argc < 2 )
		die('ERROR: Not enough parameters.' . "\n");

	$config_file			= $argv[1];
	if ( !file_exists($config_file) )
		die('ERROR: Cannot open file: ' . $config_file . "\n");

	$config					= parse_ini_file($config_file);
	$languages				= explode(',', $config['LANGUAGES']);
	$languages				= array_map('trim', $languages);
	$use_intersect			= intval($config['USE_INTERSECT']);

	$iate_xml_files			= explode(',', $config['IATE_XML']);
	$iate_xml_files			= array_map('trim', $iate_xml_files);

	chdir('IATE');
	foreach ( $languages as $i => $language ) {

		$iate_xml_file = $config['IATE_FOLDER'] . '/' . $iate_xml_files[$i];

		fwrite(STDERR, "Processing $language ...\n");
		system('php iate_simple_extract.php ' . $language . " '" . $iate_xml_file . "' '../" . $config_file . "'");
		system('php iate_forms_search.php ' . $language . " '../" . $config_file . "'");
		system('php iate_forms_lemmas.php ' . $language . " '../" . $config_file . "'");
		system('php iate_convert_lemmas.php ' . $language . " '../" . $config_file . "'");
		system('php iate_lemmas_search.php ' . $language . " '../" . $config_file . "'");
		if ( $use_intersect == 1 )
			system('php iate_lemmas_corpus.php ' . $language . " '../" . $config_file . "'");

		fwrite(STDERR, "DONE\n");
	}

	if ( $use_intersect == 1 ) {

		fwrite(STDERR, "Intersecting...\n");
		system('php iate_intersected_ids.php ' . "'../" . $config_file . "'");
		fwrite(STDERR, "DONE\n");
	}
	chdir('..');

?>