<?php

	mb_internal_encoding('UTF-8');

	if ( $argc < 2 )
		die('ERROR: Not enough parameters.' . "\n");

	$config_file			= $argv[1];
	if ( !file_exists($config_file) )
		die('ERROR: Cannot open file: ' . $config_file . "\n");

	$config					= parse_ini_file($config_file);
	$languages				= explode(',', $config['LANGUAGES']);
	$languages				= array_map('trim', $languages);
	$use_intersect			= intval($config['USE_INTERSECT']);

	chdir('Multi_Corpus');
	foreach ( $languages as $language ) {

		fwrite(STDERR, "Processing $language ...\n");
		system('php multi_corpus.php ' . $language . ' ' . "'../" . $config_file . "'");
		fwrite(STDERR, "DONE\n");
	}
	system('php multi_corpus_intersect.php ' . "'../" . $config_file . "'");
	chdir('..');

?>